#ifndef TOKEN_H
#define TOKEN_H

#include <QString>

class Token
{
public:

    enum Type
    {
        UNKNOWN,
        C_STRING,         // "string"
        C_CHAR,           // 'c'
        KEY_EQUAL,        // '='
        KEY_LEFT_BRACE,   // '{'
        KEY_RIGHT_BRACE,  // '}'
        KEY_LEFT_BAR,     // '['
        KEY_RIGHT_BAR,    // ']'
        KEY_UP,           // '^'
        KEY_PLUS,         // '-'
        KEY_COMMA,        // ','
        KEY_TILDE,        // '~'
        KEY_SNABEL,       // '@'
        KEY_STAR,         // '*'
        KEY_AND,          // '&'
        END_CODE,
        VAR
    };
public:

    Token( Type type ) : m_type( type ) {};

    static const QString &typeToString( Type type );
    Type getType() const
    {
        return m_type;
    };
    void setType( Type type )
    {
        m_type = type;
    };
    QString getString() const
    {
        return m_text;
    };

    const QString toString();

private:
    Type m_type;
public:
    QString m_text;
};

#endif // TOKEN_H
