#include "token.h"

const QString TYPE_UNKNOWN_STR = "unknown";
const QString TYPE_C_STRING_STR = "c_string";
const QString TYPE_C_CHAR_STR = "c_char";
const QString TYPE_KEY_EQUAL_STR = "=";
const QString TYPE_KEY_LEFT_BRACE_STR = "{";
const QString TYPE_KEY_RIGHT_BRACE_STR = "}";
const QString TYPE_KEY_LEFT_BAR_STR = "[";
const QString TYPE_KEY_RIGHT_BAR_STR = "]";
const QString TYPE_KEY_UP_STR = "^";
const QString TYPE_KEY_PLUS_STR = "+";
const QString TYPE_KEY_COMMA_STR = ",";
const QString TYPE_KEY_TILDE_STR = "~";
const QString TYPE_KEY_SNABEL_STR = "@";
const QString TYPE_KEY_STAR_STR = "*";
const QString TYPE_KEY_AND_STR = "&";
const QString TYPE_KEY_END_CODE_STR = "endcode";
const QString TYPE_KEY_VAR_STR = "var";
const QString QUESTION_STR = "?";


const QString Token::toString()
{
    return m_text;
}


const QString &Token::typeToString( Type type )
{
    switch ( type )
    {
        case UNKNOWN:
            return TYPE_UNKNOWN_STR;
            break;

        case C_STRING:
            return TYPE_C_STRING_STR;
            break;

        case C_CHAR:
            return TYPE_C_CHAR_STR;
            break;

        case KEY_EQUAL:
            return TYPE_KEY_EQUAL_STR;
            break;

        case KEY_LEFT_BRACE:
            return TYPE_KEY_LEFT_BRACE_STR;
            break;

        case KEY_RIGHT_BRACE:
            return TYPE_KEY_RIGHT_BRACE_STR;
            break;

        case KEY_LEFT_BAR:
            return TYPE_KEY_LEFT_BAR_STR;
            break;

        case KEY_RIGHT_BAR:
            return TYPE_KEY_RIGHT_BAR_STR;
            break;

        case KEY_UP:
            return TYPE_KEY_UP_STR;
            break;

        case KEY_PLUS:
            return TYPE_KEY_PLUS_STR;
            break;

        case KEY_COMMA:
            return TYPE_KEY_COMMA_STR;
            break;

        case KEY_TILDE:
            return TYPE_KEY_TILDE_STR;
            break;

        case KEY_SNABEL:
            return TYPE_KEY_SNABEL_STR;
            break;

        case KEY_STAR:
            return TYPE_KEY_STAR_STR;
            break;

        case KEY_AND:
            return TYPE_KEY_AND_STR;
            break;

        case END_CODE:
            return TYPE_KEY_END_CODE_STR;
            break;

        case VAR:
            return TYPE_KEY_VAR_STR;
            break;
    }

    return QUESTION_STR;
}
